//
//  MCCCoreUserAccountDelegateProtocol.h
//  MCCloud
//
//  Created by Thomas Bartelmess on 24.02.10.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum {
	MCCloudPasswordValidationResultValid,
	MCCloudPasswordValidationResultInvalid,
	MCCloudPasswordValidationResultNoUsername,
	MCCloudPasswordValidationResultNoPassword,
	MCCloudPasswordValidationResultNoPasswordNoUsername
	
} MCCloudPasswordValidationResult;

@class MCCUserController;
@protocol MCCUserControllerDelegate

@required
- (void)userController:(MCCUserController *)userController userAccountError:(NSError *)error logout:(BOOL)logout;

@optional
- (void)userController:(MCCUserController *)userController didSendPasswordResetEmailForUser:(NSString *)username;
- (void)userController:(MCCUserController *)userController faildToSendPasswordResetEmailForUser:(NSString *)username withError:(NSError *)error;

- (void)userController:(MCCUserController *)userController didResetPasswordForUser:(NSString *)username;
- (void)userController:(MCCUserController *)userController failedToResetPasswordForUser:(NSString *)username;

- (void)userController:(MCCUserController *)userController validatedPasswordForUsername:(NSString *)username withResult:(MCCloudPasswordValidationResult)result;
- (void)userController:(MCCUserController *)userController faildToValidatePasswordForUsername:(NSString *)username withError:(NSError *)error;

- (void)userController:(MCCUserController *)userController didStartService:(NSString *)serviceIdentifer;
- (void)userController:(MCCUserController *)userController failedToStartService:(NSString *)serviceIdentifer withError:(NSError *)error;

- (void)userController:(MCCUserController *)userController didStartWebservice:(NSString *)webserviceIdentifer;
- (void)userController:(MCCUserController *)userController failedToStartWebservice:(NSString *)webserviceIdentifer withError:(NSError *)error;


@end
